package ru.yandex.canvas.model.direct;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude()
public class ModerationInfo {

    @JsonProperty("content_id")
    private Long contentId;

    @JsonProperty("html")
    private Html html = new Html();

    @JsonInclude(JsonInclude.Include.ALWAYS)
    @JsonProperty("images")
    private List<Image> images = new ArrayList<>();

    @JsonInclude(JsonInclude.Include.ALWAYS)
    @JsonProperty("texts")
    private List<Text> texts;

    @JsonInclude(JsonInclude.Include.ALWAYS)
    @JsonProperty("videos")
    private List<Video> videos;

    @JsonInclude(JsonInclude.Include.ALWAYS)
    @JsonProperty("sounds")
    private List<Sound> sounds;

    @JsonInclude(JsonInclude.Include.ALWAYS)
    @JsonProperty("aspects")
    private List<Aspect> aspects;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty("admin_reject_reason")
    private String adminRejectReason;

    @JsonProperty("bgrcolor")
    private String bgrcolor;

    public Html getHtml() {
        return html;
    }

    public void setHtml(Html html) {
        this.html = html;
    }

    public List<Image> getImages() {
        return images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public List<Text> getTexts() {
        return texts;
    }

    public void setTexts(List<Text> texts) {
        this.texts = texts;
    }

    public Long getContentId() {
        return contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public List<Video> getVideos() {
        return videos;
    }

    public void setVideos(List<Video> videos) {
        this.videos = videos;
    }

    public List<Sound> getSounds() {
        return sounds;
    }

    public void setSounds(List<Sound> sounds) {
        this.sounds = sounds;
    }

    public List<Aspect> getAspects() {
        return aspects;
    }

    public void setAspects(List<Aspect> aspects) {
        this.aspects = aspects;
    }

    public String getAdminRejectReason() {
        return adminRejectReason;
    }

    public void setAdminRejectReason(String adminRejectReason) {
        this.adminRejectReason = adminRejectReason;
    }

    public String getBgrcolor() {
        return bgrcolor;
    }

    public ModerationInfo setBgrcolor(String bgrcolor) {
        this.bgrcolor = bgrcolor;
        return this;
    }

    public static class Html {
        private String url;

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    public static class Image {
        private String url;
        private String type;
        private String originalFileId;

        public String getUrl() {
            return url;
        }

        public Image setUrl(String url) {
            this.url = url;
            return this;
        }

        public String getType() {
            return type;
        }

        public Image setType(String type) {
            this.type = type;
            return this;
        }

        @Override
        public String toString() {
            return super.toString();
        }

        public String getOriginalFileId() {
            return originalFileId;
        }

        public Image setOriginalFileId(String originalFileId) {
            this.originalFileId = originalFileId;
            return this;
        }
    }

    public static class Video {
        private String stockId;
        private String url;
        private String originalFileId;

        public String getStockId() {
            return stockId;
        }

        public Video setStockId(String stockId) {
            this.stockId = stockId;
            return this;
        }

        public String getUrl() {
            return url;
        }

        public Video setUrl(String url) {
            this.url = url;
            return this;
        }

        public String getOriginalFileId() {
            return originalFileId;
        }

        public Video setOriginalFileId(String originalFileId) {
            this.originalFileId = originalFileId;
            return this;
        }
    }

    public static class Sound {
        private String stockId;
        private String url;

        public String getStockId() {
            return stockId;
        }

        public void setStockId(String stockId) {
            this.stockId = stockId;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class Aspect {
        private Long width;
        private Long height;

        public Long getWidth() {
            return width;
        }

        public void setWidth(Long width) {
            this.width = width;
        }

        public Long getHeight() {
            return height;
        }

        public void setHeight(Long height) {
            this.height = height;
        }
    }

    public static class Text {
        private String text;
        private String type;
        private String color;

        public Text() {
        }

        public Text(String text, String type, String color) {
            this.text = text;
            this.type = type;
            this.color = color;
        }

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getColor() {
            return color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        @Override
        public String toString() {
            return "Text{" +
                    "text='" + text + '\'' +
                    ", type='" + type + '\'' +
                    ", color='" + color + '\'' +
                    '}';
        }
    }

    @Override
    public String toString() {
        return "ModerationInfo{" +
                "contentId=" + contentId +
                ", html=" + html +
                ", images=" + images +
                ", texts=" + texts +
                ", videos=" + videos +
                ", sounds=" + sounds +
                ", aspects=" + aspects +
                ", bgrcolor=" + bgrcolor +
                '}';
    }
}
