package ru.yandex.canvas.model.direct;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.canvas.model.video.files.StreamFormat;
import ru.yandex.canvas.model.video.files.Thumbnail;

@JsonInclude
public class UcCreativeCanvasData {

    @JsonProperty("id")
    private Long id;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty("meta")
    private UcCanvasCreativeMeta meta;

    public UcCanvasCreativeMeta getMeta() {
        return meta;
    }

    public void setMeta(UcCanvasCreativeMeta meta) {
        this.meta = meta;
    }

    @JsonProperty("sourceUrl")
    private String sourceUrl;

    public String getSourceUrl() {
        return sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @JsonProperty("thumbUrl")
    private String thumbUrl;

    public String getThumbUrl() {
        return thumbUrl;
    }

    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    @JsonProperty("width")
    private Integer width;

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    @JsonProperty("height")
    private Integer height;

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    @JsonProperty("duration")
    private Long duration;

    public Long getDuration() {
        return duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public static final class UcCanvasCreativeMeta {
        @JsonProperty("formats")
        private List<StreamFormat> formats;

//        @JsonProperty("meta")
//        private String vast;

        @JsonProperty("mimeType")
        private String mimeType;

        @JsonProperty("status")
        private String status;

        @JsonProperty("thumb")
        private Thumbnail thumb;

        public void setFormats(List<StreamFormat> formats) {
            this.formats = formats;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setThumb(Thumbnail thumb) {
            this.thumb = thumb;
        }
    }

    public static final class UcCanvasCreativeMetaFormat {
        @JsonProperty("type")
        private String type;

        @JsonProperty("url")
        private String url;

        @JsonProperty("bitrate")
        private Long bitrate;

        public void setType(String type) {
            this.type = type;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setBitrate(Long bitrate) {
            this.bitrate = bitrate;
        }
    }

    public static class UcCanvasCreativeThumb {
        @JsonProperty("url")
        private String url;

        @JsonProperty("width")
        private Long width;

        @JsonProperty("height")
        private Long height;

        @JsonProperty("preview")
        private UcCanvasCreativeThumbPreview preview;


        public void setUrl(String url) {
            this.url = url;
        }

        public void setWidth(Long width) {
            this.width = width;
        }

        public void setHeight(Long height) {
            this.height = height;
        }

        public void setPreview(UcCanvasCreativeThumbPreview preview) {
            this.preview = preview;
        }
    }

    public static class UcCanvasCreativeThumbPreview {
        @JsonProperty("url")
        private String url;

        @JsonProperty("width")
        private Long width;

        @JsonProperty("height")
        private Long height;

        public void setUrl(String url) {
            this.url = url;
        }

        public void setWidth(Long width) {
            this.width = width;
        }

        public void setHeight(Long height) {
            this.height = height;
        }
    }
}
