package ru.yandex.canvas.model.direct;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.ALWAYS)
public class UcCreativeInfo {
    @JsonProperty("ok")
    Boolean ok;
    @JsonProperty("message")
    String message;
    @JsonProperty("creativeId")
    Long creativeId;

    @JsonInclude(JsonInclude.Include.ALWAYS)
    @JsonProperty("ucCreative")
    UcCreativeCanvasData ucCreative;

    public Boolean getOk() {
        return ok;
    }

    public UcCreativeInfo setOk(Boolean ok) {
        this.ok = ok;
        return this;
    }

    public String getMessage() {
        return message;
    }

    public UcCreativeInfo setMessage(String message) {
        this.message = message;
        return this;
    }

    public Long getCreativeId() {
        return creativeId;
    }

    public UcCreativeInfo setCreativeId(Long creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    public UcCreativeCanvasData getCreative() {
        return ucCreative;
    }

    public UcCreativeInfo setCreative(UcCreativeCanvasData creative) {
        this.ucCreative = creative;
        return this;
    }
}
