package ru.yandex.canvas.model.elements;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.validation.Valid;

import ru.yandex.canvas.model.MediaSet;
import ru.yandex.canvas.model.validation.presetbased.elements.ElementValidator;
import ru.yandex.canvas.model.validation.presetbased.elements.NotWhitespaceValidator;
import ru.yandex.canvas.model.validation.presetbased.elements.TextLengthValidator;
import ru.yandex.canvas.model.validation.presetbased.elements.ValidColorValidator;
import ru.yandex.canvas.service.rtbhost.ConstructorData.ConstructorDataElement;

/**
 * @author pupssman
 */
public class AgeRestriction extends Element {

    @Valid
    private Options options;

    @Override
    public Options getOptions() {
        return options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    @Override
    public List<ElementValidator> getDefaultValidators() {
        return List.of(
                new ValidColorValidator(),
                new NotWhitespaceValidator("value"),
                new TextLengthValidator(5, TextLengthValidator.CHOOSE_VALUE_MESSAGE, "value")
        );
    }

    @Override
    public ConstructorDataElement toRTBHostExportData(Map<String, MediaSet> mediaSets) {
        return new ConstructorDataElement(getType(), options.getColor(), options.getContent());
    }

    @Override
    public String toString() {
        return "AgeRestriction{" +
                "options=" + options +
                '}';
    }

    public static class Options extends Element.ColoredTextOptions {
        private String value;  // TODO: rename to content when agreed with petrukhin + add regexp
        private String color;

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String getColor() {
            return color;
        }

        @Override
        public void setColor(String color) {
            this.color = color;
        }

        @Override
        public Collection<String> getTexts() {
            return Collections.singleton(value);
        }

        @Override
        public String toString() {
            return "Options{" +
                    "value='" + value + '\'' +
                    ", color='" + color + '\'' +
                    '}';
        }

        @Override
        public String getContent() {
            return value;
        }

        @Override
        public void setContent(String content) {
            this.value = content;
        }
    }
}
