package ru.yandex.canvas.model.elements;

import java.util.List;
import java.util.Map;

import javax.validation.Valid;

import ru.yandex.adv.direct.media.ElementOptions;
import ru.yandex.canvas.model.MediaSet;
import ru.yandex.canvas.model.validation.presetbased.elements.ElementValidator;
import ru.yandex.canvas.model.validation.presetbased.elements.ValidColorValidator;
import ru.yandex.canvas.service.rtbhost.ConstructorData.ConstructorDataElement;

/**
 * @author pupssman
 */
public class Fade extends Element {
    @Valid
    private Options options;

    @Override
    public List<ElementValidator> getDefaultValidators() {
        return List.of(
                new ValidColorValidator()
        );
    }

    @Override
    public ConstructorDataElement toRTBHostExportData(Map<String, MediaSet> mediaSets) {
        return null;  // nothing to export here
    }

    @Override
    public Options getOptions() {
        return options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    @Override
    public String toString() {
        return "Fade{" +
                "options=" + options +
                '}';
    }

    public static final class Options extends Element.Options implements OptionsWithColor {
        private String color;

        public Options(String color) {
            this.color = color;
        }

        public Options() {
        }

        public String getColor() {
            return color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        @Override
        public String toString() {
            return "Options{" +
                    "color='" + color + '\'' +
                    '}';
        }

        @Override
        protected void fillProto(ElementOptions.Builder builder) {
            if (color != null) {
                builder.setColor(color);
            }
        }
    }
}
