package ru.yandex.canvas.model.elements;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.validation.Valid;

import ru.yandex.adv.direct.media.ElementOptions;
import ru.yandex.canvas.model.MediaSet;
import ru.yandex.canvas.model.validation.presetbased.elements.ElementValidator;
import ru.yandex.canvas.model.validation.presetbased.elements.NotWhitespaceValidator;
import ru.yandex.canvas.model.validation.presetbased.elements.TextLengthValidator;
import ru.yandex.canvas.model.validation.presetbased.elements.ValidColorValidator;
import ru.yandex.canvas.model.validation.presetbased.elements.ValidUnicodeSymbolsValidator;
import ru.yandex.canvas.service.rtbhost.ConstructorData.ConstructorDataElement;

/**
 * @author skirsanov
 */
public class Legal extends Element {
    @Valid
    private Options options;

    @Override
    public Options getOptions() {
        return options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    @Override
    public List<ElementValidator> getDefaultValidators() {
        return List.of(
                new ValidUnicodeSymbolsValidator(),
                new ValidColorValidator(),
                new NotWhitespaceValidator(),
                new TextLengthValidator(700)
        );
    }

    @Override
    public ConstructorDataElement toRTBHostExportData(Map<String, MediaSet> mediaSets) {
        return new ConstructorDataElement(getType(), options.getColor(), options.getContent());
    }

    @Override
    public String toString() {
        return "Legal{" +
                "options=" + options +
                '}';
    }

    public static class Options extends Element.ColoredTextOptions {
        private String content;
        private String color;
        private String iconColor;

        @Override
        public String getContent() {
            return content;
        }

        @Override
        public void setContent(String content) {
            this.content = content;
        }

        @Override
        public String getColor() {
            return color;
        }

        @Override
        public void setColor(String color) {
            this.color = color;
        }

        public String getIconColor() {
            return iconColor;
        }

        public void setIconColor(String iconColor) {
            this.iconColor = iconColor;
        }

        @Override
        public Collection<String> getTexts() {
            return Collections.singleton(content);
        }

        @Override
        public String toString() {
            return "Options{" +
                    "content='" + content + '\'' +
                    ", color='" + color + '\'' +
                    ", iconColor='" + iconColor + '\'' +
                    '}';
        }

        @Override
        protected void fillProto(ElementOptions.Builder builder) {
            super.fillProto(builder);
            if (iconColor != null) {
                builder.setIconColor(iconColor);
            }
        }
    }
}
