package ru.yandex.canvas.model.elements;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

import ru.yandex.canvas.model.MediaSet;
import ru.yandex.canvas.model.validation.presetbased.elements.ElementValidator;
import ru.yandex.canvas.model.validation.presetbased.elements.NotWhitespaceValidator;
import ru.yandex.canvas.model.validation.presetbased.elements.ValidColorValidator;
import ru.yandex.canvas.model.validation.presetbased.elements.ValidUnicodeSymbolsValidator;
import ru.yandex.canvas.service.rtbhost.ConstructorData;

public class Phone extends Element {

    @Valid
    private Phone.Options options;

    @Override
    public Phone.Options getOptions() {
        return options;
    }

    public void setOptions(Phone.Options options) {
        this.options = options;
    }

    @Override
    public List<ElementValidator> getDefaultValidators() {
        return List.of(
                new ValidUnicodeSymbolsValidator(),
                new ValidColorValidator(),
                new NotWhitespaceValidator()
        );
    }

    @Override
    public ConstructorData.ConstructorDataElement toRTBHostExportData(Map<String, MediaSet> mediaSets) {
        return new ConstructorData.ConstructorDataElement(getType(), options.getColor(), options.getContent());
    }

    @Override
    public String toString() {
        return "Phone{" +
                "options=" + options +
                '}';
    }

    public static class Options extends Element.ColoredTextOptions {
        @Pattern(regexp = "^\\+?\\d{4,15}") // 15 цифр максимум для international плюс "+"
        private String content;
        private String color;


        public Options() {
        }

        public Options(@NotNull String content, String color) {
            this.content = content;
            this.color = color;
        }

        @Override
        public String getContent() {
            return content;
        }

        @Override
        public void setContent(String content) {
            this.content = content;
        }

        @Override
        public String getColor() {
            return color;
        }

        @Override
        public void setColor(String color) {
            this.color = color;
        }


        @Override
        public Collection<String> getTexts() {
            return Collections.singleton(content);
        }

        @Override
        public String toString() {
            return "Options{" +
                    "content='" + content + '\'' +
                    ", color='" + color + '\'' +
                    '}';
        }
    }
}
