package ru.yandex.canvas.model.html5;

import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Field;

import ru.yandex.canvas.model.CreativeWithAdminRejectReason;
import ru.yandex.canvas.model.CreativeWithId;
import ru.yandex.canvas.model.CreativeWithScreenshot;
import ru.yandex.canvas.service.SessionParams;

public class Creative implements CreativeWithScreenshot, CreativeWithId, CreativeWithAdminRejectReason {

    public static final String ID_FIELD_NAME = "id";
    public static final String WIDTH_FIELD_NAME = "width";
    public static final String HEIGHT_FIELD_NAME = "height";
    public static final String SOURCE_FIELD_NAME = "source";
    public static final String SCREENSHOT_URL_FIELD_NAME = "screenshot_url";
    public static final String SCREENSHOT_IS_DONE_FIELD_NAME = "screenshot_is_done";
    public static final String ADMIN_REJECT_REASON = "admin_reject_reason";

    @NotNull
    @Indexed(unique = true)
    @Field("id") // overwise it'll be put to _id and converted to ObjectId("..")
    private Long id;

    @NotNull
    @Field("archive_url")
    @JsonProperty("archive_url")
    private String archiveUrl;

    @NotNull
    @Field("preview_url")
    @JsonProperty("preview_url")
    private String previewUrl;

    @NotNull
    @Field(SCREENSHOT_URL_FIELD_NAME)
    @JsonProperty(SCREENSHOT_URL_FIELD_NAME)
    private String screenshotUrl;

    @Field("screenshot_is_done")
    @JsonProperty("screenshot_is_done")
    private Boolean screenshotIsDone;

    @Field("is_brand_lift")
    @JsonProperty("is_brand_lift")
    private Boolean isBrandLift;

    @NotNull
    @Field("base_path")
    @JsonProperty("base_path")
    private String basePath;

    @NotNull
    private Integer height;

    @NotNull
    private Integer width;

    @NotNull
    @JsonProperty(SOURCE_FIELD_NAME)
    private Source source;

    @NotNull
    private String name;

    @Transient // stored in batch
    private String batchId;

    @Transient // stored in batch
    private SessionParams.SessionTag productType;

    @NotNull
    @Field("source_image_info")
    @JsonProperty("source_image_info")
    private Source.ImageStillageInfo sourceImageInfo;

    @Transient
    private Boolean available;

    @Transient
    private Boolean expanded;

    @Transient
    private String expandedHtmlUrl;// stored in source

    @Transient
    private String validationError;// stored in source

    @Nullable
    @Field(ADMIN_REJECT_REASON)
    @JsonProperty(ADMIN_REJECT_REASON)
    private String adminRejectReason;

    public Long getId() {
        return id;
    }

    @Override
    public Long fetchCreativeId() {
        return getId();
    }

    @Override
    public String fetchScreenshotUrl() {
        return getScreenshotUrl();
    }

    @Override
    public Boolean fetchScreenshotIsDone() {
        return getScreenshotIsDone();
    }

    public Creative setId(Long id) {
        this.id = id;
        return this;
    }

    public String getArchiveUrl() {
        return archiveUrl;
    }

    public Creative setArchiveUrl(String archiveUrl) {
        this.archiveUrl = archiveUrl;
        return this;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public Creative setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }

    public String getScreenshotUrl() {
        return screenshotUrl;
    }

    public Creative setScreenshotUrl(String screenshotUrl) {
        this.screenshotUrl = screenshotUrl;
        return this;
    }

    public Boolean getScreenshotIsDone() {
        return screenshotIsDone;
    }

    public Creative setScreenshotIsDone(Boolean screenshotIsDone) {
        this.screenshotIsDone = screenshotIsDone;
        return this;
    }

    public Boolean getIsBrandLift() {
        return isBrandLift;
    }

    public Creative setIsBrandLift(Boolean isBrandLift) {
        this.isBrandLift = isBrandLift;
        return this;
    }

    public String getBasePath() {
        return basePath;
    }

    public Creative setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public Creative setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public Creative setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Source getSource() {
        return source;
    }

    public Creative setSource(Source source) {
        this.source = source;
        return this;
    }

    public String getName() {
        return name;
    }

    public Creative setName(String name) {
        this.name = name;
        return this;
    }

    public String getBatchId() {
        return batchId;
    }

    public Creative setBatchId(String batchId) {
        this.batchId = batchId;
        return this;
    }

    public SessionParams.SessionTag getProductType() {
        return productType;
    }

    public Creative setProductType(SessionParams.SessionTag productType) {
        this.productType = productType;
        return this;
    }

    public Source.ImageStillageInfo getSourceImageInfo() {
        return sourceImageInfo;
    }

    public Creative setSourceImageInfo(Source.ImageStillageInfo sourceImageInfo) {
        this.sourceImageInfo = sourceImageInfo;
        return this;
    }

    public Boolean getAvailable() {
        return available;
    }

    public Creative setAvailable(Boolean available) {
        this.available = available;
        return this;
    }

    public Boolean getExpanded() {
        return expanded;
    }

    public String getExpandedHtmlUrl() {
        return expandedHtmlUrl;
    }

    public Creative setExpandedHtmlUrl(String expandedHtmlUrl) {
        this.expandedHtmlUrl = expandedHtmlUrl;
        return this;
    }

    public String getValidationError() {
        return validationError;
    }

    public Creative setValidationError(String validationError) {
        this.validationError = validationError;
        return this;
    }

    public Creative setExpanded(Boolean expanded) {
        this.expanded = expanded;
        return this;
    }

    @Nullable
    public String getAdminRejectReason() {
        return adminRejectReason;
    }

    public void setAdminRejectReason(@Nullable String adminRejectReason) {
        this.adminRejectReason = adminRejectReason;
    }
}
