package ru.yandex.canvas.model.ideas;

import java.util.List;
import java.util.stream.Collectors;

import org.jetbrains.annotations.NotNull;

import ru.yandex.canvas.model.File;
import ru.yandex.canvas.model.Files;
import ru.yandex.canvas.model.IdeaDocument;
import ru.yandex.canvas.model.stillage.StillageFileInfo;

public class IdeaFilesHelper {
    private IdeaFilesHelper() {
    }

    public static Files extractFiles(@NotNull IdeaDocument idea) {
        List<File> files = idea.getScraperData().getImages().stream().map(stillageImage -> {
                    File ideaFile = generateFakeFile(idea, stillageImage);
                    ideaFile.setId(stillageImage.getId());
                    return ideaFile;
                }
        ).collect(Collectors.toList());
        return new Files(files, files.size());
    }

    public static File generateFakeFile(@NotNull IdeaDocument idea, @NotNull StillageFileInfo stillageFileInfo) {
        File fakeFile = new File();
        fakeFile.setClientId(idea.getClientId());
        fakeFile.setStillageFileId(stillageFileInfo.getId());
        fakeFile.setStillageFileInfo(stillageFileInfo);
        fakeFile.setUrl(stillageFileInfo.getUrl());
        fakeFile.setThumbnailUrl(stillageFileInfo.getUrl());
        fakeFile.setPreviewUrl(stillageFileInfo.getUrl());
        fakeFile.setLargePreviewUrl(stillageFileInfo.getUrl());
        fakeFile.setCropSourceUrl(stillageFileInfo.getUrl());
        fakeFile.setDate(idea.getDate());
        fakeFile.setName(stillageFileInfo.getId());
        return fakeFile;
    }
}
