package ru.yandex.canvas.model.mds;

import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

import org.asynchttpclient.Response;

import ru.yandex.direct.http.smart.converter.ResponseConverter;
import ru.yandex.inside.mds.MdsMultipartPostResponse;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.parse.BenderParser;

public class MdsResponseConverter implements ResponseConverter<MdsMultipartPostResponse>  {
    // маппер из библиотеки iceberg, которая исторически использовалась для взаимодействия с mds,
    // скорее всего можно переделать на обычный нормальный jackson xml
    private static final BenderMapper benderMapper = new BenderMapper(BenderConfiguration.defaultConfiguration());

    @Override
    public MdsMultipartPostResponse convert(Response response, Type responseType) {
        String responseBody = response.getResponseBody(StandardCharsets.UTF_8);

        BenderParser<MdsMultipartPostResponse> parser = benderMapper.createParser(MdsMultipartPostResponse.class);
        return parser.parseXml(responseBody);
    }
}
