package ru.yandex.canvas.model.presets;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import static java.util.function.Function.identity;
import static java.util.stream.Collectors.toMap;

public enum PresetTag {
    COMMON("common"),
    CPM_GEOPRODUCT("cpm_geoproduct"),
    CPM_GEO_PIN("cpm_geo_pin"),
    IN_BANNER("in_banner");

    private static final Map<String, PresetTag> tagsByName = Arrays
            .stream(PresetTag.values())
            .collect(toMap(PresetTag::toString, identity()));

    private final String value;

    PresetTag(String value) {
        this.value = value;
    }

    @JsonCreator
    @Nonnull
    public static PresetTag parse(String s) {
        return Optional
                .ofNullable(tagsByName.get(s))
                .orElseThrow(() -> new RuntimeException("Unknown preset tag: " + s));
    }

    @Override
    @JsonValue
    public String toString() {
        return value;
    }
}
