package ru.yandex.canvas.model.scraper;


import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.canvas.model.stillage.StillageFileInfo;

public class ScraperData {

    private final List<StillageFileInfo> images;
    private final List<StillageFileInfo> logos;
    private final ScraperColors colors;
    private final ScraperTexts texts;
    private final String hostname;

    @JsonCreator
    public ScraperData(@JsonProperty("images") List<StillageFileInfo> images,
                       @JsonProperty("logos") List<StillageFileInfo> logos,
                       @JsonProperty("colors") ScraperColors colors,
                       @JsonProperty("texts") ScraperTexts texts,
                       @JsonProperty("hostname") String hostname
    ) {
        this.images = images;
        this.logos = logos;
        this.colors = colors;
        this.texts = texts;
        this.hostname = hostname;
    }

    public List<StillageFileInfo> getImages() {
        return images;
    }

    public List<StillageFileInfo> getLogos() {
        return logos;
    }

    public ScraperColors getColors() {
        return colors;
    }

    public ScraperTexts getTexts() {
        return texts;
    }

    public String getHostname() {
        return hostname;
    }

    @Override
    public String toString() {
        return "ScraperData{" +
                "images=" + images.stream().map(StillageFileInfo::toString).collect(Collectors.joining(", ")) +
                ", logos=" + logos.stream().map(StillageFileInfo::toString).collect(Collectors.joining(", ")) +
                ", colors=" + colors +
                ", texts=" + texts +
                '}';
    }

    public static class ScraperColors {
        private final String background;
        private final String border;
        private final String text;
        private final String button;
        private final String buttonText;

        public ScraperColors(@JsonProperty("background") String background,
                             @JsonProperty("border") String border,
                             @JsonProperty("text") String text,
                             @JsonProperty("button") String button,
                             @JsonProperty("button_text") String buttonText) {
            this.background = background;
            this.border = border;
            this.text = text;
            this.button = button;
            this.buttonText = buttonText;
        }

        public String getBackground() {
            return background;
        }

        public String getBorder() {
            return border;
        }

        public String getText() {
            return text;
        }

        public String getButton() {
            return button;
        }

        public String getButtonText() {
            return buttonText;
        }

        @Override
        public String toString() {
            return "ScraperColors{" +
                    "background='" + background + '\'' +
                    ", border='" + border + '\'' +
                    ", text='" + text + '\'' +
                    ", button='" + button + '\'' +
                    ", buttonText='" + buttonText + '\'' +
                    '}';
        }
    }

    public static class ScraperTexts {
        private String title;
        private String description;

        @JsonCreator
        public ScraperTexts(@JsonProperty("title") String title, @JsonProperty("description") String description) {
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return title;
        }

        public String getDescription() {
            return description;
        }

        @Override
        public String toString() {
            return "ScraperTexts{" +
                    "title='" + title + '\'' +
                    ", description='" + description + '\'' +
                    '}';
        }
    }
}
