package ru.yandex.canvas.model.stillage;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.canvas.service.video.VideoMetaData;

public class StillageInfoConverter {

    private final ObjectMapper objectMapper;

    public StillageInfoConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public VideoMetaData toVideoMetaData(StillageFileInfo info) {
        VideoMetaData videoMetaData = objectMapper.convertValue(info.getMetadataInfo(), VideoMetaData.class);

        // Если у аудио- или видео-потоков не указана длительность, то её можно взять из основной метаинформации
        if (videoMetaData.getVideoStreams() != null) {
            videoMetaData.getVideoStreams().forEach(videoStream -> {
                if (videoStream.getDuration() == null) {
                    videoStream.setDuration(videoMetaData.getDuration());
                }
            });
        }
        if (videoMetaData.getAudioStreams() != null) {
            videoMetaData.getAudioStreams().forEach(audioStream -> {
                if (audioStream.getBaseInfo().getDuration() == null) {
                    audioStream.getBaseInfo().setDuration(videoMetaData.getDuration());
                }
            });
        }

        return videoMetaData;
    }

}
