package ru.yandex.canvas.model.stock;

import java.util.List;

import org.jetbrains.annotations.Nullable;

import ru.yandex.canvas.model.stillage.StillageFileInfo;

/**
 * @author pupssman
 */
public class StockFile {
    private String id;
    /**
     * Optional field
     */
    private String name;
    private String url;
    private String previewUrl;
    private String thumbnailUrl;
    private String largePreviewUrl;
    private String cropSourceUrl;
    /**
     * IDs for {@link StockCategory} objects that this file has.
     * <b>id</b> is a stillage file ID and file contents should be similar to those in stillage for that ID
     */
    private List<Integer> categories;

    private StillageFileInfo stillageFileInfo;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Nullable
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public List<Integer> getCategories() {
        return categories;
    }

    public void setCategories(List<Integer> categories) {
        this.categories = categories;
    }

    public String getLargePreviewUrl() {
        return largePreviewUrl;
    }

    public void setLargePreviewUrl(String largePreviewUrl) {
        this.largePreviewUrl = largePreviewUrl;
    }

    public StillageFileInfo getStillageFileInfo() {
        return stillageFileInfo;
    }

    public void setStillageFileInfo(StillageFileInfo stillageFileInfo) {
        this.stillageFileInfo = stillageFileInfo;
    }

    public String getCropSourceUrl() {
        return cropSourceUrl;
    }

    public void setCropSourceUrl(String cropSourceUrl) {
        this.cropSourceUrl = cropSourceUrl;
    }

    @Override
    public String toString() {
        return "StockFile{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", url='" + url + '\'' +
                ", previewUrl='" + previewUrl + '\'' +
                ", thumbnailUrl='" + thumbnailUrl + '\'' +
                ", largePreviewUrl='" + largePreviewUrl + '\'' +
                ", cropSourceUrl='" + cropSourceUrl + '\'' +
                ", categories=" + categories +
                ", stillageFileInfo=" + stillageFileInfo +
                '}';
    }
}
