package ru.yandex.canvas.model.validation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.canvas.model.CreativeData;

public class DifferentlyColoredCreativeOptionsValidator
        implements ConstraintValidator<DifferentlyColoredOptions, CreativeData.Options> {

    private static final Logger logger = LoggerFactory.getLogger(DifferentlyColoredCreativeOptionsValidator.class);

    private double distance;
    private DifferentlyColoredOptions.Metric metric;

    @Override
    public void initialize(DifferentlyColoredOptions constraint) {
        distance = constraint.distance();
        metric = constraint.metric();
    }


    @Override
    public boolean isValid(CreativeData.Options options, ConstraintValidatorContext context) {
        boolean isValid;
        try {
            isValid = !metric.almostTheSameColors(options.getBackgroundColor(), options.getBorderColor(), distance);
        } catch (NumberFormatException e) {
            logger.warn("can't compute color difference", e);
            isValid = true;
        }
        if (!isValid) {
            context.disableDefaultConstraintViolation();

            context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate())
                    .addPropertyNode("borderColor").addConstraintViolation();
            context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate())
                    .addPropertyNode("backgroundColor").addConstraintViolation();
        }
        return isValid;
    }
}
