package ru.yandex.canvas.model.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

@Target({ElementType.FIELD, ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = IsNullValidator.class)
public @interface IsNull {

    String message() default "{field_is_not_null}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
