package ru.yandex.canvas.model.validation;


import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = {CreativeDocumentBatchPresetBasedValidator.class, CreativeDocumentPresetBasedValidator.class})
public @interface PresetBasedValidation {
    String message() default "Preset-based validation failed";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
