package ru.yandex.canvas.model.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import javax.validation.constraints.Pattern;

import ru.yandex.canvas.model.validation.presetbased.elements.ValidColorValidator;


@Target({ElementType.FIELD, ElementType.METHOD})
@Pattern(regexp = ValidColorValidator.COLOR_PATTERN)
@ReportAsSingleViolation
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = {})
public @interface ValidColor {

    String message() default ValidColorValidator.MESSAGE;

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
