package ru.yandex.canvas.model.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

@Constraint(validatedBy = {ValidHtml5SizeValidator.class})
@Target({ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ValidHtml5Size {
    String message() default "Not a proper size";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
