package ru.yandex.canvas.model.validation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import ru.yandex.canvas.Html5Constants;
import ru.yandex.canvas.model.Size;

public class ValidHtml5SizeValidator implements ConstraintValidator<ValidHtml5Size, String> {
    @Override
    public void initialize(ValidHtml5Size constraintAnnotation) {
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        String[] wnh = value.split("x");
        return wnh.length == 2 && Html5Constants.VALID_SIZES_GENERAL.contains(
                Size.of(Integer.parseInt(wnh[0]), Integer.parseInt(wnh[1])));
    }
}
