package ru.yandex.canvas.model.validation;

import java.util.List;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import ru.yandex.canvas.Html5Constants;
import ru.yandex.canvas.model.Size;

public class ValidHtml5SizesListValidator implements ConstraintValidator<ValidHtml5SizesList, List<String>> {
    @Override
    public void initialize(ValidHtml5SizesList constraintAnnotation) {
    }

    @Override
    public boolean isValid(List<String> sizes, ConstraintValidatorContext context) {
        if (sizes == null || sizes.isEmpty()) {
            return true;
        }
        for (String size : sizes) {
            String[] wnh = size.split("x");
            if (wnh.length != 2 || !Html5Constants.VALID_SIZES_GENERAL.contains(
                    Size.of(Integer.parseInt(wnh[0]), Integer.parseInt(wnh[1])))) {
                return false;
            }
        }
        return true;
    }
}
