package ru.yandex.canvas.model.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

/**
 * Forbid > 3 bytes utf-8 symbols.
 *
 * @see <a href="https://st.yandex-team.ru/DIRECT-75602">DIRECT-75602</a>
 */
@Constraint(validatedBy = {ValidUnicodeSymbolsValidator.class})
@Target({ElementType.FIELD, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ValidUnicodeSymbols {
    String message() default "{invalid_symbols}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
