package ru.yandex.canvas.model.validation;

import java.lang.annotation.ElementType;

import javax.validation.Path;
import javax.validation.Path.Node;
import javax.validation.TraversableResolver;

import ru.yandex.canvas.model.CreativeDocument;
import ru.yandex.canvas.model.elements.Element;
import ru.yandex.canvas.model.video.addition.AdditionElement;

public class ValidateOnlyAvailableElementsAndCreatives implements TraversableResolver {

    @Override
    public boolean isReachable(Object traversableObject, Node traversableProperty, Class<?> rootBeanType,
                               Path pathToTraversableObject, ElementType elementType) {
        return true;
    }

    @Override
    public boolean isCascadable(Object traversableObject, Node traversableProperty, Class<?> rootBeanType,
                                Path pathToTraversableObject, ElementType elementType) {
        if (traversableObject instanceof AdditionElement && "options".equals(traversableProperty.getName())) {
            return ((AdditionElement) traversableObject).getAvailable();
        }

        if (traversableObject instanceof Element && "options".equals(traversableProperty.getName())) {
            return ((Element) traversableObject).getAvailable();
        }

        if (traversableObject instanceof CreativeDocument) {
            return ((CreativeDocument) traversableObject).getAvailable();
        }

        return true;
    }

}
