package ru.yandex.canvas.model.validation;

import org.springframework.validation.BindingResult;

/**
 * Есть валидация на базе аннотаций (JSR-303/JSR-349 Bean Validation) - общепринятый способ валидировать запросы в
 * Spring
 * <p>
 * Т.к. сложную логику писать на анотация не удобно, и не всю валидацию можно сделать на стадии обработки запроса, есть
 * написана императиваная валидация, на входе которой валидируемый объект, на выходе он же обернутый в
 * {@link BindingResult}
 * <p>
 * Для ответа, BindingResult можно кинуть исключением, завернув его в
 * {@link ru.yandex.canvas.exceptions.ValidationResultRepresentationException}
 * В котором есть логика по конвертации BindingResult в ответ сервиса специфично контексту, на каждый контекст
 * (контроллер) делается свой эксепшн.
 * <p>
 * Обработку эксепшена можно посмотреть в {@link ru.yandex.canvas.configs.GlobalExceptionHandler}
 * <p>
 * Пример реализации валидация в {@link ru.yandex.canvas.service.video.VideoAdditionValidationService}
 *
 * @param <T>
 */
public interface Validator<T> {
    BindingResult validate(T t);
}
