package ru.yandex.canvas.model.validation.presetbased;

import javax.validation.constraints.NotNull;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.validation.Errors;

/**
 * Абстрактный валидатор произвольной части креатива. Конкретный тип валидатора и настройки указываются в preset-описании.
 *
 * @param <T> класс валидируемой сущности
 */
public abstract class AbstractValidator<T> {

    @NotNull
    private String type;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean validateIfSupported(T target, @NonNull Errors errors) {
        if (!isSupported(target)) {
            return false;
        }
        validate(target, errors);
        return true;
    }

    public abstract boolean isSupported(T target);

    public abstract void validate(T target, @NonNull Errors errors);
}
