package ru.yandex.canvas.model.validation.presetbased.creative;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

import ru.yandex.canvas.model.CreativeData;
import ru.yandex.canvas.model.validation.presetbased.AbstractValidator;

/**
 * Абстрактный валидатор {@link CreativeData}. Конкретный тип валидатора и наcтройки указываются в preset-описании.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible =
        true)
@JsonSubTypes({
        @JsonSubTypes.Type(value = AllowedDomainsValidator.class, name = CreativeDataValidatorTypes.ALLOWED_DOMAINS),
        @JsonSubTypes.Type(value = CroppedImageValidator.class, name = CreativeDataValidatorTypes.CROPPED_IMAGE),
        @JsonSubTypes.Type(value = ElementsAvailabilityValidator.class, name =
                CreativeDataValidatorTypes.ELEMENTS_AVAILABILITY),
        @JsonSubTypes.Type(value = ImageFileSizeValidator.class, name = CreativeDataValidatorTypes.IMAGE_FILE_SIZE),
        @JsonSubTypes.Type(value = ImageSizeValidator.class, name = CreativeDataValidatorTypes.IMAGE_SIZE),
        @JsonSubTypes.Type(value = ValidImageValidator.class, name = CreativeDataValidatorTypes.VALID_IMAGE),
        @JsonSubTypes.Type(value = ValidInBannerVideoValidator.class, name = CreativeDataValidatorTypes.VALID_VIDEO),
        @JsonSubTypes.Type(value = ValidCreativeColorValidator.class, name =
                CreativeDataValidatorTypes.VALID_CREATIVE_COLOR),
})
public abstract class CreativeDataValidator extends AbstractValidator<CreativeData> {
}
