package ru.yandex.canvas.model.validation.presetbased.creative;

import java.util.List;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.validation.Errors;

import ru.yandex.canvas.model.CreativeData;
import ru.yandex.canvas.model.MediaSet;
import ru.yandex.canvas.model.elements.Element;

public class CroppedImageValidator extends MediaSetValidator<Element> {

    public static final String MESSAGE = "{image_not_cropped}";

    public CroppedImageValidator() {
    }

    public CroppedImageValidator(List<String> elementTypes) {
        super(elementTypes);
    }

    @Override
    protected void validate(Element element, MediaSet mediaSet, CreativeData creativeData, @NonNull Errors errors) {
        // require croppedFileId if fileId is given (let ValidImageValidator check file is given)
        boolean allValid = getSubItems(mediaSet).stream()
                .allMatch(item -> item.getCroppedFileId() != null || item.getFileId() == null);

        if (!allValid) {
            errors.rejectValue(null, "image.not.cropped", new String[]{
                    "height", String.valueOf(creativeData.getHeight()),
                    "width", String.valueOf(creativeData.getWidth()),
            }, MESSAGE);
        }
    }
}
