package ru.yandex.canvas.model.validation.presetbased.creative;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import javax.annotation.Nonnull;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.validation.Errors;

import ru.yandex.canvas.model.CreativeData;
import ru.yandex.canvas.model.File;
import ru.yandex.canvas.model.MediaSet;
import ru.yandex.canvas.model.elements.Element;
import ru.yandex.canvas.model.stillage.StillageFileInfo;
import ru.yandex.canvas.model.validation.FileServiceContainer;
import ru.yandex.canvas.service.FileService;

public class ImageSizeValidator extends MediaSetValidator<Element> implements FileServiceContainer {

    private static final String MESSAGE = "{logo_too_big_or_doesnt_fit}";

    @Nonnull
    private Integer maxHeight;

    public void setMaxHeight(Integer maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Nonnull
    private Integer maxWidth;

    public void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
    }

    @Nonnull
    private Integer maxFileSize;

    public void setMaxFileSize(Integer maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public ImageSizeValidator() {
    }

    public ImageSizeValidator(@Nonnull List<String> elementTypes, @Nonnull Integer maxHeight,
                              @Nonnull Integer maxWidth, @Nonnull Integer maxFileSize) {
        super(elementTypes);
        this.maxHeight = maxHeight;
        this.maxWidth = maxWidth;
        this.maxFileSize = maxFileSize;
    }

    private FileService fileService;

    @Override
    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    @Override
    protected void validate(Element element, MediaSet mediaSet, CreativeData creativeData, @NonNull Errors errors) {
        for (String fileId : getFileIds(mediaSet)) {
            Optional<File> maybeFile = fileService.getByIdInternal(fileId);
            if (maybeFile.isEmpty()) {
                continue;
            }
            File file = maybeFile.get();
            StillageFileInfo stillageFileInfo = file.getStillageFileInfo();
            if (stillageFileInfo == null) {
                continue;
            }
            Map<String, Object> metadataInfo = stillageFileInfo.getMetadataInfo();
            if (stillageFileInfo.getFileSize() > maxFileSize
                    || (Integer) metadataInfo.get("height") > maxHeight
                    || (Integer) metadataInfo.get("width") > maxWidth) {
                errors.rejectValue(null, "size", new String[]{
                        "maxFileSize", String.valueOf(maxFileSize),
                        "maxWidth", String.valueOf(maxWidth),
                        "maxHeight", String.valueOf(maxHeight)
                }, MESSAGE);
                return;
            }
        }
    }
}
