package ru.yandex.canvas.model.validation.presetbased.creative;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.validation.Errors;

import ru.yandex.canvas.model.CreativeData;
import ru.yandex.canvas.model.validation.presetbased.elements.ValidColorValidator;

public class ValidCreativeColorValidator extends CreativeDataValidator {

    @Override
    public boolean isSupported(CreativeData creative) {
        return creative != null && creative.getOptions() != null;
    }

    @Override
    public void validate(CreativeData creative, @NonNull Errors errors) {
        CreativeData.Options options = creative.getOptions();

        ValidColorValidator.checkColor(options.getBackgroundColor(), "options.backgroundColor", errors);
        ValidColorValidator.checkColor(options.getBorderColor(), "options.borderColor", errors);
    }
}
