package ru.yandex.canvas.model.validation.presetbased.creative;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.validation.Errors;

import ru.yandex.canvas.model.CreativeData;
import ru.yandex.canvas.model.MediaSet;
import ru.yandex.canvas.model.MediaSetSubItem;
import ru.yandex.canvas.model.elements.Element;
import ru.yandex.canvas.model.elements.Image;

/**
 * Validates {@link Image}s and {@link ru.yandex.canvas.model.elements.Logo}s of a {@link CreativeData} for integrity
 * <p>
 * Checks that each image:
 * <li> has a proper <b>mediaSet</b> defined
 * <li> that such a <b>mediaSet</b> exists
 * <li> all of it's subItems have an {@link MediaSetSubItem#getEffectiveFileId()} not null
 */
public class ValidImageValidator extends MediaSetValidator<Element> {

    public static final String MESSAGE = "{image_not_uploaded}";

    @Override
    protected void validate(Element element, MediaSet mediaSet, CreativeData creativeData, @NonNull Errors errors) {
        if (mediaSet != null) {
            boolean allValid = getSubItems(mediaSet).stream()
                    .allMatch(item -> item.getEffectiveFileId() != null || item.isDefaultValue());
            if (allValid) {
                return;
            }
        }

       errors.rejectValue(null, "image.not.uploaded", MESSAGE);
    }
}
