package ru.yandex.canvas.model.validation.presetbased.elements;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

import ru.yandex.canvas.model.elements.Element;
import ru.yandex.canvas.model.validation.presetbased.AbstractValidator;

/**
 * Абстрактный валидатор элемента креатива. Конкретный тип валидатора и настройки указываются в preset-описании.
 *
 * @param <E> класс элемента
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true)
@JsonSubTypes({
        @JsonSubTypes.Type(value = TextLengthValidator.class, name = ElementValidatorTypes.TEXT_LENGTH),
        @JsonSubTypes.Type(value = NotWhitespaceValidator.class, name = ElementValidatorTypes.NOT_WHITESPACE),
        @JsonSubTypes.Type(value = UrlValidator.class, name = ElementValidatorTypes.URL),
        @JsonSubTypes.Type(value = ValidColorValidator.class, name = ElementValidatorTypes.VALID_COLOR),
        @JsonSubTypes.Type(value = ValidUnicodeSymbolsValidator.class, name = ElementValidatorTypes.VALID_UNICODE_SYMBOLS),
})
public abstract class ElementValidator<E extends Element> extends AbstractValidator<E> {
}
