package ru.yandex.canvas.model.video;

import java.util.Date;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.IndexDirection;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import ru.yandex.canvas.model.video.files.FileStatus;
import ru.yandex.canvas.service.video.VideoCreativeType;

@Document(collection = "audio_files")
public class AudioFiles {
    @Id
    private String id;

    @Field("previewUrl")
    private String previewUrl;

    @Field("client_id")
    private Long clientId;

    @Field("name")
    private String name;

    @Field("stillage_id")
    private String stillageId;

    @Field("date")
    private Date date;

    @Field("url")
    private String url;

    @Field("archive")
    private Boolean archive;

    @Field("duration")
    private Double duration;

    @Field("status")
    @Indexed(direction = IndexDirection.ASCENDING)
    private FileStatus status;

    @Field("creativeType")
    private VideoCreativeType creativeType;

    public String getId() {
        return id;
    }

    public AudioFiles setId(String id) {
        this.id = id;
        return this;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public AudioFiles setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public AudioFiles setClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getName() {
        return name;
    }

    public AudioFiles setName(String name) {
        this.name = name;
        return this;
    }

    public String getStillageId() {
        return stillageId;
    }

    public AudioFiles setStillageId(String stillageId) {
        this.stillageId = stillageId;
        return this;
    }

    public Date getDate() {
        return date;
    }

    public AudioFiles setDate(Date date) {
        this.date = date;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public AudioFiles setUrl(String url) {
        this.url = url;
        return this;
    }

    public Boolean getArchive() {
        return archive;
    }

    public AudioFiles setArchive(Boolean archive) {
        this.archive = archive;
        return this;
    }

    public Double getDuration() {
        return duration;
    }

    public AudioFiles setDuration(Double duration) {
        this.duration = duration;
        return this;
    }

    public FileStatus getStatus() {
        return status;
    }

    public AudioFiles setStatus(FileStatus status) {
        this.status = status;
        return this;
    }

    public VideoCreativeType getCreativeType() {
        return creativeType;
    }

    public AudioFiles setCreativeType(VideoCreativeType creativeType) {
        this.creativeType = creativeType;
        return this;
    }

    @Override
    public String toString() {
        return "AudioFiles{" +
                "id='" + id + '\'' +
                ", previewUrl='" + previewUrl + '\'' +
                ", clientId=" + clientId +
                ", name='" + name + '\'' +
                ", stillageId=" + stillageId +
                ", date=" + date +
                ", url='" + url + '\'' +
                ", archive=" + archive +
                ", duration=" + duration +
                ", status=" + status +
                ", creativeType=" + creativeType +
                '}';
    }
}
