package ru.yandex.canvas.model.video;

import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import ru.yandex.canvas.model.CreativeWithId;

@Document(collection = "stock_video_additions")
@CompoundIndexes({
        @CompoundIndex(def = "{'preset_id': 1, 'video_id': 1, 'audio_id': 1, 'locale': 1}", unique = true),
})
public class StockAddition extends Addition implements CreativeWithId {

    @Field("locale")
    private String locale;

    @Field("video_id")
    private String videoId;

    @Field("audio_id")
    private String audioId;

    @Override
    public Long fetchCreativeId() { // совпадает с Addition, переопределно для пущей ясности
        return getCreativeId(); // всегда совпадает со stock_creative_id
    }

    public String getLocale() {
        return locale;
    }

    public StockAddition setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public String getVideoId() {
        return videoId;
    }

    public StockAddition setVideoId(String videoId) {
        this.videoId = videoId;
        return this;
    }

    public String getAudioId() {
        return audioId;
    }

    public StockAddition setAudioId(String audioId) {
        this.audioId = audioId;
        return this;
    }

    public Addition makeAddtionFromStock() {

        return new Addition()
                .setCreativeId(null)
                .setId(null)
                .setData(this.getData())
                .setPresetId(this.getPresetId())
                .setVast(this.getVast())
                .setArchive(this.getArchive())
                .setClientId(this.getClientId())
                .setDate(null)
                .setScreenshotUrl(this.getScreenshotUrl())
                .setName(this.getName())
                .setStockCreativeId(this.getCreativeId());
    }

}
