package ru.yandex.canvas.model.video;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.canvas.service.video.AdParams;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class TrackingEvents {

    public static final String RENDER_TRACKING_URL = AdParams.RTB_HOST_TRACKING_URL_MACRO + "?action-id=11";

    public static final String TRUE_VIEW_TRACKING_URL = AdParams.RTB_HOST_TRACKING_URL_MACRO + "?action-id=19";

    public static final String SHOW_HP_URL = AdParams.RTB_HOST_TRACKING_URL_MACRO + "?action-id=21";
    public static final String CLICK_HP_URL = AdParams.RTB_HOST_TRACKING_URL_MACRO + "?action-id=22";
    public static final String ADS_FINISH_URL = AdParams.RTB_HOST_TRACKING_URL_MACRO + "?action-id=24";

    /**
     * по сути это событие render, DIRECT-104377
     */
    @JsonProperty("start")
    private List<String> startUrls;

    /**
     * событие "просмотра" видео, https://st.yandex-team.ru/DIRECT-126829
     */
    @JsonProperty("trueView")
    private List<String> trueViewUrls;

    /**
     * событие быстрых кликов, https://st.yandex-team.ru/DIRECT-135455
     */
    @JsonProperty("returnAfterClickThrough")
    private List<String> returnAfterClickThroughUrls;

    @JsonProperty("showHp")
    private List<String> showHp;

    @JsonProperty("clickHp")
    private List<String> clickHp;

    @JsonProperty("adsFinish")
    private List<String> adsFinish;

    public TrackingEvents setStartUrls(List<String> startUrls) {
        this.startUrls = startUrls;
        return this;
    }

    public TrackingEvents setTrueViewUrls(List<String> trueViewUrls) {
        this.trueViewUrls = trueViewUrls;
        return this;
    }

    public TrackingEvents setReturnAfterClickThroughUrls(List<String> returnAfterClickThroughUrls) {
        this.returnAfterClickThroughUrls = returnAfterClickThroughUrls;
        return this;
    }

    public TrackingEvents setShowHp(List<String> showHp) {
        this.showHp = showHp;
        return this;
    }

    public TrackingEvents setClickHp(List<String> clickHp) {
        this.clickHp = clickHp;
        return this;
    }

    public TrackingEvents setAdsFinish(List<String> adsFinish) {
        this.adsFinish = adsFinish;
        return this;
    }
}
