package ru.yandex.canvas.model.video;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.IndexDirection;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import ru.yandex.canvas.model.stillage.StillageFileInfo;
import ru.yandex.canvas.model.video.files.FileStatus;
import ru.yandex.canvas.model.video.files.FileType;
import ru.yandex.canvas.service.video.VideoCreativeType;

@Document(collection = "video_files")
@CompoundIndexes({
        @CompoundIndex(def = "{'client_id': 1, 'stillage_id': 1, 'duration': 1, 'stock_file_id':1, 'type':1, "
                + "'name':1}", unique = true),
})
public class VideoFiles {

    @Id
    private String id;

    @Field("largePreviewUrl")
    private String largePreviewUrl;

    @Field("previewUrl")
    private String previewUrl;

    @Field("client_id")
    private Long clientId;

    @Field("name")
    private String name;

    @Field("stillage_id")
    private Long stillageId;

    @Field("type")
    private FileType type;

    @Field("overlayColor")
    private String overlayColor;

    @Field("creation_time")
    private Date creationTime;

    @Field("date")
    private Date date;

    @Field("sub_categories")
    private List<String> subCategories;

    @Field("stock_file_id")
    private String stockFileId;

    @Field("url")
    private String url;

    @Field("stillage_info")
    private StillageFileInfo stillageFileInfo; //TODO custom class for database

    @Field("archive")
    private Boolean archive;

    @Field("status")
    @Indexed(direction = IndexDirection.ASCENDING)
    private FileStatus status;

    @Field("conversion_task_id")
    private Long convertionTaskId;

    @Field("video_meta_id")
    private BigInteger videoMetaId;//идентификатор видео в VH CMS

    @Field("player_id")
    private String playerId;//идентификатор видео в VH CMS

    @Field("formats")
    private List<VideoFormat> formats;

    @Field("strm_prefix")
    private String strmPrefix;

    @Field("firstFrameUrl")
    private String firstFrameUrl;

    @Field("signaturesUrl")
    private String signaturesUrl;

    @Field("inputHeight")
    private Long inputHeight;

    @Field("inputWidth")
    private Long inputWidth;

    @Field("thumbnailUrl")
    private String thumbnailUrl;

    @Field("thumbnail")
    private VideoThumbnail thumbnail;

    @Field("duration")
    private Double duration;

    @Field("ratio")
    private String ratio;

    //соотношение ширины к высоте в процентах. Целое число. Нужно для фильтрации и сортировки.
    @Field("ratio_percent")
    private Integer ratioPercent;

    @Field("creativeType")
    private VideoCreativeType creativeType;

    public VideoCreativeType getCreativeType() {
        return creativeType;
    }

    public VideoFiles setCreativeType(VideoCreativeType creativeType) {
        this.creativeType = creativeType;
        return this;
    }

    public String getLargePreviewUrl() {
        return largePreviewUrl;
    }

    public VideoFiles setLargePreviewUrl(String largePreviewUrl) {
        this.largePreviewUrl = largePreviewUrl;
        return this;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public VideoFiles setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }

    public String getRatio() {
        return ratio;
    }

    public VideoFiles setRatio(String ratio) {
        this.ratio = ratio;
        return this;
    }

    public Integer getRatioPercent() {
        return ratioPercent;
    }

    public VideoFiles setRatioPercent(Integer ratioPercent) {
        this.ratioPercent = ratioPercent;
        return this;
    }

    public static class VideoThumbnail {
        @Field
        private String url;
        @Field
        private Long width;
        @Field
        private Long height;

        @Field
        private ThumbnailPreview preview;

        public ThumbnailPreview getPreview() {
            return preview;
        }

        public VideoThumbnail setPreview(ThumbnailPreview preview) {
            this.preview = preview;
            return this;
        }

        public static class ThumbnailPreview {
            @Field
            private String url;
            @Field
            private Long width;
            @Field
            private Long height;

            public String getUrl() {
                return url;
            }

            public ThumbnailPreview setUrl(String url) {
                this.url = url;
                return this;
            }

            public Long getWidth() {
                return width;
            }

            public ThumbnailPreview setWidth(Long width) {
                this.width = width;
                return this;
            }

            public Long getHeight() {
                return height;
            }

            public ThumbnailPreview setHeight(Long height) {
                this.height = height;
                return this;
            }
        }

        public String getUrl() {
            return url;
        }

        public VideoThumbnail setUrl(String url) {
            this.url = url;
            return this;
        }

        public Long getWidth() {
            return width;
        }

        public VideoThumbnail setWidth(Long width) {
            this.width = width;
            return this;
        }

        public Long getHeight() {
            return height;
        }

        public VideoThumbnail setHeight(Long height) {
            this.height = height;
            return this;
        }
    }

    public static class VideoFormat {
        @Field("delivery")
        private String delivery;

        @Field("width")
        private String width;

        @Field("url")
        private String url;

        @Field("type")
        @JsonProperty("type")
        private String mimeType;

        @Field("bitrate")
        private Long bitrate;

        @Field("id")
        private String id;

        @Field("height")
        private String height;

        @Field("size")
        private String size;

        @Field("path")
        private String path;

        @Field("codec")
        private String codec;

        @Field("framerate")
        private Integer framerate;

        @Field("fileSize")
        private Long fileSize;

        @Field("hasAudio")
        private Boolean hasAudio;

        @Field("vmafAvg")
        private Double vmafAvg;

        @Field("formatName")
        private String formatName;

        @Field("TagsStr")
        private List<String> tagsStr;

        public String getPath() {
            return path;
        }

        public VideoFormat setPath(String path) {
            this.path = path;
            return this;
        }

        public String getSize() {
            return size;
        }

        public VideoFormat setSize(String size) {
            this.size = size;
            return this;
        }

        public String getDelivery() {
            return delivery;
        }

        public String getWidth() {
            return width;
        }

        public String getUrl() {
            return url;
        }

        public String getMimeType() {
            return mimeType;
        }

        public Long getBitrate() {
            return bitrate;
        }

        public String getId() {
            return id;
        }

        public String getHeight() {
            return height;
        }

        public VideoFormat setDelivery(String delivery) {
            this.delivery = delivery;
            return this;
        }

        public VideoFormat setWidth(String width) {
            this.width = width;
            return this;
        }

        public VideoFormat setUrl(String url) {
            this.url = url;
            return this;
        }

        public VideoFormat setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public VideoFormat setBitrate(Long bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public VideoFormat setId(String id) {
            this.id = id;
            return this;
        }

        public VideoFormat setHeight(String height) {
            this.height = height;
            return this;
        }

        public String getCodec() {
            return codec;
        }

        public VideoFormat setCodec(String codec) {
            this.codec = codec;
            return this;
        }

        public Integer getFramerate() {
            return framerate;
        }

        public VideoFormat setFramerate(Integer framerate) {
            this.framerate = framerate;
            return this;
        }

        public Long getFileSize() {
            return fileSize;
        }

        public VideoFormat setFileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public Boolean getHasAudio() {
            return hasAudio;
        }

        public VideoFormat setHasAudio(Boolean hasAudio) {
            this.hasAudio = hasAudio;
            return this;
        }

        public Double getVmafAvg() {
            return vmafAvg;
        }

        public VideoFormat setVmafAvg(Double vmafAvg) {
            this.vmafAvg = vmafAvg;
            return this;
        }

        public String getFormatName() {
            return formatName;
        }

        public VideoFormat setFormatName(String formatName) {
            this.formatName = formatName;
            return this;
        }

        public List<String> getTagsStr() {
            return tagsStr;
        }

        public VideoFormat setTagsStr(List<String> tagsStr) {
            this.tagsStr = tagsStr;
            return this;
        }
    }

    public Double getDuration() {
        return duration;
    }

    public VideoFiles setDuration(Double duration) {
        this.duration = duration;
        return this;
    }

    public String getStockFileId() {
        return stockFileId;
    }

    public String getId() {
        return id;
    }

    public Long getClientId() {
        return clientId;
    }

    public String getName() {
        return name;
    }

    public Long getStillageId() {
        return stillageId;
    }

    public FileType getType() {
        return type;
    }

    public String getOverlayColor() {
        return overlayColor;
    }

    public Date getCreationTime() {
        return creationTime;
    }

    public Date getDate() {
        return date;
    }

    public List<String> getSubCategories() {
        return subCategories;
    }

    public String getUrl() {
        return url;
    }

    public StillageFileInfo getStillageFileInfo() {
        return stillageFileInfo;
    }

    public Boolean getArchive() {
        return archive;
    }

    public FileStatus getStatus() {
        return status;
    }

    public Long getConvertionTaskId() {
        return convertionTaskId;
    }

    public BigInteger getVideoMetaId() {
        return videoMetaId;
    }
    public String getPlayerId() {
        return playerId;
    }

    public List<VideoFormat> getFormats() {
        return formats;
    }

    public String getStrmPrefix() {
        return strmPrefix;
    }

    public String getFirstFrameUrl() {
        return firstFrameUrl;
    }

    public VideoFiles setFirstFrameUrl(String firstFrameUrl) {
        this.firstFrameUrl = firstFrameUrl;
        return this;
    }

    public String getSignaturesUrl() {
        return signaturesUrl;
    }

    public VideoFiles setSignaturesUrl(String signaturesUrl) {
        this.signaturesUrl = signaturesUrl;
        return this;
    }


    public Long getInputHeight() {
        return inputHeight;
    }

    public VideoFiles setInputHeight(Long inputHeight) {
        this.inputHeight = inputHeight;
        return this;
    }

    public Long getInputWidth() {
        return inputWidth;
    }

    public VideoFiles setInputWidth(Long inputWidth) {
        this.inputWidth = inputWidth;
        return this;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public VideoThumbnail getThumbnail() {
        return thumbnail;
    }

    public VideoFiles setId(String id) {
        this.id = id;
        return this;
    }

    public VideoFiles setClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public VideoFiles setName(String name) {
        this.name = name;
        return this;
    }

    public VideoFiles setStillageId(Long stillageId) {
        this.stillageId = stillageId;
        return this;
    }

    public VideoFiles setType(FileType type) {
        this.type = type;
        return this;
    }

    public VideoFiles setOverlayColor(String overlayColor) {
        this.overlayColor = overlayColor;
        return this;
    }

    public VideoFiles setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public VideoFiles setDate(Date date) {
        this.date = date;
        return this;
    }

    public VideoFiles setSubCategories(List<String> subCategories) {
        this.subCategories = subCategories;
        return this;
    }

    public VideoFiles setStockFileId(String stockFileId) {
        this.stockFileId = stockFileId;
        return this;
    }

    public VideoFiles setUrl(String url) {
        this.url = url;
        return this;
    }

    public VideoFiles setStillageFileInfo(StillageFileInfo stillageFileInfo) {
        this.stillageFileInfo = stillageFileInfo;
        return this;
    }

    public VideoFiles setArchive(Boolean archive) {
        this.archive = archive;
        return this;
    }

    public VideoFiles setStatus(FileStatus status) {
        this.status = status;
        return this;
    }

    public VideoFiles setConvertionTaskId(Long convertionTaskId) {
        this.convertionTaskId = convertionTaskId;
        return this;
    }

    public VideoFiles setVideoMetaId(BigInteger videoMetaId) {
        this.videoMetaId = videoMetaId;
        return this;
    }

    public VideoFiles setPlayerId(String playerId) {
        this.playerId = playerId;
        return this;
    }

    public VideoFiles setFormats(List<VideoFormat> formats) {
        this.formats = formats;
        return this;
    }

    public VideoFiles setStrmPrefix(String strmPrefix) {
        this.strmPrefix = strmPrefix;
        return this;
    }

    public VideoFiles setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
        return this;
    }

    public VideoFiles setThumbnail(VideoThumbnail thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    @Override
    public String toString() {
        return "VideoFiles{" +
                "id='" + id + '\'' +
                ", largePreviewUrl='" + largePreviewUrl + '\'' +
                ", previewUrl='" + previewUrl + '\'' +
                ", clientId=" + clientId +
                ", name='" + name + '\'' +
                ", stillageId=" + stillageId +
                ", type=" + type +
                ", overlayColor='" + overlayColor + '\'' +
                ", date=" + date +
                ", subCategories=" + subCategories +
                ", stockFileId='" + stockFileId + '\'' +
                ", url='" + url + '\'' +
                ", stillageFileInfo=" + stillageFileInfo +
                ", archive=" + archive +
                ", status=" + status +
                ", convertionTaskId=" + convertionTaskId +
                ", videoMetaId=" + videoMetaId +
                ", playerId=" + playerId +
                ", formats=" + formats +
                ", strmPrefix='" + strmPrefix + '\'' +
                ", thumbnailUrl='" + thumbnailUrl + '\'' +
                ", thumbnail=" + thumbnail +
                ", duration=" + duration +
                ", ratio='" + ratio + '\'' +
                ", creativeType=" + creativeType +
                '}';
    }
}
