package ru.yandex.canvas.model.video.addition;

import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.springframework.data.mongodb.core.mapping.Field;

@JsonInclude(JsonInclude.Include.ALWAYS)
public class AdditionData {
    @NotNull
    @Valid
    @Field("bundle")
    private AdditionDataBundle bundle;

    @NotNull
    @Valid
    @Field("elements")
    private List<AdditionElement> elements;

    public AdditionDataBundle getBundle() {
        return bundle;
    }

    public AdditionData setBundle(AdditionDataBundle bundle) {
        this.bundle = bundle;
        return this;
    }

    public List<AdditionElement> getElements() {
        return elements;
    }

    public AdditionData setElements(
            List<AdditionElement> elements) {
        this.elements = elements;
        return this;
    }
}
