package ru.yandex.canvas.model.video.addition;

import java.io.IOException;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import org.springframework.data.mongodb.core.mapping.Field;

import ru.yandex.canvas.model.video.addition.options.OptionName;

/*
    This class has dynamically built validator depended on current Preset
 */

public class Options<T extends Options> {

    @Field("background_color")
    @JsonProperty("background_color")
    protected String backgroundColor;

    @Field("text_color")
    @JsonProperty("text_color")
    protected String textColor;

    protected String text;

    protected String placeholder;

    @Field("video_id")
    @JsonProperty("video_id")
    protected String videoId;

    @Field("audio_id")
    @JsonProperty("audio_id")
    protected String audioId;

    @Field("overlay_id")
    @JsonProperty("overlay_id")
    protected String overlayId;

    @Field("packshot_id")
    @JsonProperty("packshot_id")
    protected String packshotId;

    @Field("border_color")
    @JsonProperty("border_color")
    protected String borderColor;

    @JsonProperty("position")
    protected String position;

    @JsonProperty("custom_label")
    protected String customLabel;

    protected String color;

    public void serializeForPcode(JsonGenerator gen) throws IOException {
        throw new IllegalStateException("This method must be called only from inherited subclass");
    }

    public String getBackgroundColor() {
        return backgroundColor;
    }

    public T setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return (T) this;
    }

    public String getTextColor() {
        return textColor;
    }

    public T setTextColor(String textColor) {
        this.textColor = textColor;
        return (T) this;
    }

    public String getText() {
        return text;
    }

    public T setText(String text) {
        this.text = text;
        return (T) this;
    }

    public String getPlaceholder() {
        return placeholder;
    }

    public T setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return (T) this;
    }

    public String getVideoId() {
        return videoId;
    }

    public T setVideoId(String videoId) {
        this.videoId = videoId;
        return (T) this;
    }

    public String getAudioId() {
        return audioId;
    }

    public T setAudioId(String audioId) {
        this.audioId = audioId;
        return (T) this;
    }

    public String getPackshotId() {
        return packshotId;
    }

    public T setPackshotId(String packshotId) {
        this.packshotId = packshotId;
        return (T) this;
    }

    public String getOverlayId() {
        return overlayId;
    }

    public T setOverlayId(String overlayId) {
        this.overlayId = overlayId;
        return (T) this;
    }

    public String getBorderColor() {
        return borderColor;
    }

    public T setBorderColor(String borderColor) {
        this.borderColor = borderColor;
        return (T) this;
    }

    public String getColor() {
        return color;
    }

    public T setColor(String color) {
        this.color = color;
        return (T) this;
    }

    public String getPosition() {
        return position;
    }

    public T setPosition(String position) {
        this.position = position;
        return (T) this;
    }

    public String getCustomLabel() {
        return customLabel;
    }

    public T setCustomLabel(String customLabel) {
        this.customLabel = customLabel;
        return (T) this;
    }

    public void copyFieldsTo(Options options) {
        options.setBackgroundColor(getBackgroundColor());
        options.setTextColor(getTextColor());
        options.setText(getText());
        options.setPlaceholder(getPlaceholder());
        options.setVideoId(getVideoId());
        options.setAudioId(getAudioId());
        options.setOverlayId(getOverlayId());
        options.setPackshotId(getPackshotId());
        options.setBorderColor(getBorderColor());
        options.setColor(getColor());
        options.setPosition(getPosition());
        options.setCustomLabel(getCustomLabel());
    }

    public String optionByName(String nameString) {
        OptionName name = OptionName.fromValue(nameString);
        return optionByName(name);
    }

    public String optionByName(OptionName name) {
        final String value;
        switch (name) {
            case TEXT:
                value = getText();
                break;
            case TEXT_COLOR:
                value = getTextColor();
                break;
            case BACKGROUND_COLOR:
                value = getBackgroundColor();
                break;
            case PLACEHOLDER:
                value = getPlaceholder();
                break;
            case VIDEO_ID:
                value = getVideoId();
                break;
            case AUDIO_ID:
                value = getAudioId();
                break;
            case OVERLAY_ID:
                value = getOverlayId();
                break;
            case PACKSHOT_ID:
                value = getPackshotId();
                break;
            case BORDER_COLOR:
                value = getBorderColor();
                break;
            case COLOR:
                value = getColor();
                break;
            case POSITION:
                value = getPosition();
                break;
            case CUSTOM_LABEL:
                value = getCustomLabel();
                break;
            default:
                throw new IllegalStateException("unknown option name " + name);

        }
        return value;
    }
}
