package ru.yandex.canvas.model.video.addition;

import java.util.Locale;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.canvas.MongoLowerCaseEnum;

public enum RtbStatus implements MongoLowerCaseEnum {
    SENT,
    NEW;

    @JsonValue
    public String getValue() {
        return name().toLowerCase();
    }

    @JsonCreator
    public static RtbStatus fromString(String name) {
        return RtbStatus.valueOf(name.toUpperCase(Locale.ROOT));
    }
}
