package ru.yandex.canvas.model.video.addition.options;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;

import ru.yandex.canvas.model.video.addition.Options;

public class AgeElementOptions extends Options<AgeElementOptions> {
    @Override
    public void serializeForPcode(JsonGenerator gen) throws IOException {

        if (getBackgroundColor() != null) {
            gen.writeStringField("AGE_BACKGROUND_COLOR", getBackgroundColor());
        }

        if (getTextColor() != null) {
            gen.writeStringField("AGE_TEXT_COLOR", getTextColor());
        }

        if (getText() != null) {
            gen.writeStringField("AGE_TEXT", getText());
        }

        if (getPlaceholder() != null) {
            gen.writeStringField("AGE_PLACEHOLDER", getText());
        }
    }

    public AgeElementOptions(Options options) {
        options.copyFieldsTo(this);
    }

    public AgeElementOptions() {
    }
}
