package ru.yandex.canvas.model.video.addition.options;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;

import ru.yandex.canvas.model.video.addition.Options;

public class BodyElementOptions extends Options<BodyElementOptions> {

    @Override
    public void serializeForPcode(JsonGenerator gen) throws IOException {

        if (getBackgroundColor() != null) {
            gen.writeStringField("BODY_BACKGROUND_COLOR", getBackgroundColor());
        }

        if (getTextColor() != null) {
            gen.writeStringField("BODY_TEXT_COLOR", getTextColor());
        }

        if (getText() != null) {
            gen.writeStringField("BODY_TEXT", getText());
        }

        if (getPlaceholder() != null) {
            gen.writeStringField("BODY_PLACEHOLDER", getText());
        }
    }

    public BodyElementOptions(Options options) {
        options.copyFieldsTo(this);
    }

    public BodyElementOptions() {
    }

}
