package ru.yandex.canvas.model.video.addition.options;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

import com.fasterxml.jackson.core.JsonGenerator;

import ru.yandex.canvas.model.video.addition.Options;

public class ButtonElementOptions extends Options<ButtonElementOptions> {

    public ButtonElementOptions() {

    }

    @Override
    public void serializeForPcode(JsonGenerator gen) throws IOException {
        if (getTextColor() != null) {
            gen.writeStringField("BUTTON_TEXT_COLOR", getTextColor());
        }

        if (getText() != null) {
            gen.writeStringField("BUTTON_TEXT", getText());
        }

        if (getPlaceholder() != null) {
            gen.writeStringField("BUTTON_PLACEHOLDER", getPlaceholder());
        }

        // always convert value to the empty string as per BANNERSTORAGE-5416
        gen.writeStringField("BUTTON_BORDER_COLOR", "");

        if (getColor() != null) {
            gen.writeStringField("BUTTON_COLOR", getColor());
        }

        if (getPosition() != null) {
            gen.writeStringField("BUTTON_POSITION", getPosition());
        }

        if (getCustomLabel() != null && !"—".equals(getCustomLabel())) {
            Map<String, String> labels = new LinkedHashMap<>();
            labels.put("ru", getCustomLabel());
            labels.put("en", getCustomLabel());
            labels.put("tr", getCustomLabel());
            gen.writeObjectField("BUTTON_LABELS", labels);
        }
    }

    // always convert value to the empty string as per BANNERSTORAGE-5416
    @Override
    public ButtonElementOptions setBorderColor(String color) {
        return super.setBorderColor(null);
    }

    public ButtonElementOptions(Options options) {
        options.copyFieldsTo(this);
    }
}
