package ru.yandex.canvas.model.video.addition.options;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;

import ru.yandex.canvas.model.video.addition.Options;

public class DisclaimerElementOptions extends Options<DisclaimerElementOptions> {

    @Override
    public void serializeForPcode(JsonGenerator gen) throws IOException {
        if (getBackgroundColor() != null) {
            gen.writeStringField("DISCLAIMER_BACKGROUND_COLOR", getBackgroundColor());
        }

        if (getTextColor() != null) {
            gen.writeStringField("DISCLAIMER_TEXT_COLOR", getTextColor());
        }

        if (getText() != null) {
            gen.writeStringField("DISCLAIMER_TEXT", getText());
        }

        if (getPlaceholder() != null) {
            gen.writeStringField("DISCLAIMER_PLACEHOLDER", getPlaceholder());
        }
    }

    public DisclaimerElementOptions(Options options) {
        options.copyFieldsTo(this);
    }

    public DisclaimerElementOptions() {
    }
}
