package ru.yandex.canvas.model.video.addition.options;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;

import ru.yandex.canvas.model.video.addition.Options;

public class DomainElementOptions extends Options<DomainElementOptions> {
    public DomainElementOptions() {

    }

    @Override
    public void serializeForPcode(JsonGenerator gen) throws IOException {
        if (getBackgroundColor() != null) {
            gen.writeStringField("DOMAIN_BACKGROUND_COLOR", getBackgroundColor());
        }

        if (getTextColor() != null) {
            gen.writeStringField("DOMAIN_TEXT_COLOR", getTextColor());
        }

        if (getText() != null) {
            gen.writeStringField("DOMAIN_TEXT", getText());
        }

        if (getPlaceholder() != null) {
            gen.writeStringField("DOMAIN_PLACEHOLDER", getPlaceholder());
        }
    }

    public DomainElementOptions(Options options) {
        options.copyFieldsTo(this);
    }
}
