package ru.yandex.canvas.model.video.addition.options;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;

import ru.yandex.canvas.model.video.addition.Options;

public class LegalElementOptions extends Options<LegalElementOptions> {
    @Override
    public void serializeForPcode(JsonGenerator gen) throws IOException {
        if (getBackgroundColor() != null) {
            gen.writeStringField("LEGAL_BACKGROUND_COLOR", getBackgroundColor());
        }

        if (getTextColor() != null) {
            gen.writeStringField("LEGAL_TEXT_COLOR", getTextColor());
        }

        if (getText() != null) {
            gen.writeStringField("LEGAL_TEXT", getText());
        }

        if (getPlaceholder() != null) {
            gen.writeStringField("LEGAL_PLACEHOLDER", getPlaceholder());
        }
    }

    public LegalElementOptions(Options options) {
        options.copyFieldsTo(this);
    }

    public LegalElementOptions() {
    }
}
