package ru.yandex.canvas.model.video.addition.options;

import com.google.common.base.CaseFormat;

public enum OptionName {
    AUDIO_ID("audio_id"),
    VIDEO_ID("video_id"),
    OVERLAY_ID("overlay_id"),
    PACKSHOT_ID("packshot_id"),
    TEXT("text"),
    TEXT_COLOR("text_color"),
    BACKGROUND_COLOR("background_color"),
    BORDER_COLOR("border_color"),
    PLACEHOLDER("placeholder"),
    COLOR("color"),
    POSITION("position"),
    CUSTOM_LABEL("custom_label");

    private String name;

    OptionName(String name) {
        this.name = name;
    }

    public String toValue() {
        return this.name;
    }

    /**
     * Возвращает имя поля модели соответствующее названию опции
     *
     * @return
     */
    public String toFieldName() {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, toValue());
    }

    public static OptionName fromValue(String value) {
        for (OptionName name : OptionName.values()) {
            if (name.toValue().equals(value)) {
                return name;
            }
        }
        throw new IllegalArgumentException("Enum for '" + value + "' not found");
    }
}
