package ru.yandex.canvas.model.video.addition.options;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Strings;

import ru.yandex.canvas.model.video.addition.Options;

public class SubtitlesElementOptions extends Options<SubtitlesElementOptions> {
    @Override
    public void serializeForPcode(JsonGenerator gen) throws IOException {
        //DIRECT-136676 договорились выводить значение субтитров в VAST в особом формате
        if (!Strings.isNullOrEmpty(getText())) {
            Map<String, String> subtitles = Map.of("vtt", getText());
            gen.writeObjectField("subtitles", subtitles);
        }
    }

    public SubtitlesElementOptions(Options options) {
        options.copyFieldsTo(this);
    }

    public SubtitlesElementOptions() {
    }
}
