package ru.yandex.canvas.model.video.addition.options;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;

import ru.yandex.canvas.model.video.addition.Options;

public class TitleElementOptions extends Options<TitleElementOptions> {

    @Override
    public void serializeForPcode(JsonGenerator gen) throws IOException {
        if (getBackgroundColor() != null) {
            gen.writeStringField("TITLE_BACKGROUND_COLOR", getBackgroundColor());
        }

        if (getTextColor() != null) {
            gen.writeStringField("TITLE_TEXT_COLOR", getTextColor());
        }

        if (getText() != null) {
            gen.writeStringField("TITLE_TEXT", getText());
        }

        if (getPlaceholder() != null) {
            gen.writeStringField("TITLE_PLACEHOLDER", getPlaceholder());
        }
    }

    public TitleElementOptions(Options options) {
        options.copyFieldsTo(this);
    }

    public TitleElementOptions() {
    }
}
