package ru.yandex.canvas.model.video.files;

import java.util.Locale;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.canvas.MongoLowerCaseEnum;

public enum FileStatus implements MongoLowerCaseEnum {
    READY,
    SEMI_READY,
    ERROR,
    CONVERTING,
    NEW;

    @JsonValue
    public String getValue() {
        return name().toLowerCase();
    }

    @JsonCreator
    public static FileStatus fromString(String name) {
        return FileStatus.valueOf(name.toUpperCase(Locale.ROOT));
    }
}
