package ru.yandex.canvas.model.video.files;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.canvas.model.video.VideoFiles;

public class InBannerVideo {
    private final String categoryId;
    private final Thumbnail thumbnail;
    private final String overlayColor;
    private final String stillageId;
    private final String name;
    private final String id;
    private final String stillageUrl;
    private final String ratio;
    private final String stockId;
    private final Date date;
    private final Long clientId;
    private final String mimeType;
    private List<StreamFormat> formats;
    private final Long taskId;
    private final FileStatus fileStatus;
    private final Boolean archive;
    private final Double duration;
    private final String strmPrefix;

    public InBannerVideo(VideoFiles record) {
        duration = record.getDuration();
        categoryId = null;
        thumbnail = record.getThumbnail() == null ? null : new Thumbnail(record.getThumbnail());
        overlayColor = record.getOverlayColor();
        stillageId = record.getStillageId() + "";
        name = record.getName();
        date = record.getDate();
        id = record.getId();
        stockId = null;
        stillageUrl = record.getStillageFileInfo() == null ? null : record.getStillageFileInfo().getUrl();
        ratio = record.getRatio() == null ? "16:9" : record.getRatio();
        mimeType = record.getStillageFileInfo() == null ? null : record.getStillageFileInfo().getMimeType();
        clientId = record.getClientId();
        taskId = record.getConvertionTaskId();
        formats = record.getFormats() == null ? Collections.emptyList()
                : record.getFormats().stream().map(StreamFormat::new).collect(Collectors.toList());
        fileStatus = record.getStatus();
        archive = record.getArchive();
        strmPrefix = record.getStrmPrefix();
    }

    public InBannerVideo(Movie record) {
        duration = record.getDuration();
        categoryId = null;
        thumbnail = record.getVideoSource().getThumbnail();
        overlayColor = record.getVideoSource().getOverlayColor();
        stillageId = record.getVideoSource().getStillageId() + "";
        name = record.getVideoSource().getName();
        date = record.getVideoSource().getDate();
        id = record.getVideoSource().getId();
        stockId = null;
        stillageUrl = record.getVideoSource().getStillageUrl();
        ratio = "16:9";
        mimeType = record.getVideoSource().getMimeType();
        clientId = null;
        taskId = record.getConvertionTaskId();
        formats = record.getFormats();
        fileStatus = record.getStatus();
        archive = record.getArchive();
        strmPrefix = record.getStrmPrefix();
    }

    public String getStrmPrefix() {
        return strmPrefix;
    }

    public String getCategoryId() {
        return categoryId;
    }

    public Thumbnail getThumbnail() {
        return thumbnail;
    }

    public String getOverlayColor() {
        return overlayColor;
    }

    public String getStillageId() {
        return stillageId;
    }

    public String getName() {
        return name;
    }

    public String getId() {
        return id;
    }

    public String getStillageUrl() {
        return stillageUrl;
    }

    public String getRatio() {
        return ratio;
    }

    public String getStockId() {
        return stockId;
    }

    public Date getDate() {
        return date;
    }

    public Long getClientId() {
        return clientId;
    }

    public String getMimeType() {
        return mimeType;
    }

    public List<StreamFormat> getFormats() {
        return formats;
    }

    public Long getConvertionTaskId() {
        return taskId;
    }

    public FileStatus getStatus() {
        return fileStatus;
    }

    public Boolean getArchive() {
        return archive;
    }

    public Double getDuration() {
        return duration;
    }
}
