package ru.yandex.canvas.model.video.files;

import java.util.List;
import java.util.Set;

import ru.yandex.canvas.service.video.VideoCreativeType;

import static ru.yandex.canvas.VideoConstants.CANVAS_ASYNC_VIDEO_CREATIVE_CREATION_FEATURE;

public class Movie {

    public Movie(VideoSource videoSource, AudioSource audioSource, List<StreamFormat> formats, String strmPrefix,
                 String stillageUrl, Long convertionTaskId, boolean isStock, FileStatus status, Double duration,
                 Boolean archive) {
        this.videoSource = videoSource;
        this.audioSource = audioSource;
        this.formats = formats;
        this.strmPrefix = strmPrefix;
        this.stillageUrl = stillageUrl;
        this.convertionTaskId = convertionTaskId;
        this.isStock = isStock;
        this.status = status;
        this.duration = duration;
        this.archive = archive;
    }

    private VideoSource videoSource;
    private AudioSource audioSource;
    private List<StreamFormat> formats;
    private String strmPrefix;
    private String stillageUrl;
    private Long convertionTaskId;
    private boolean isStock;
    private FileStatus status;
    private Double duration;
    private Boolean archive;
    private String estKaltura;
    private String estMobileVertical;

    public Boolean getArchive() {
        return archive;
    }

    public VideoSource getVideoSource() {
        return videoSource;
    }

    public AudioSource getAudioSource() {
        return audioSource;
    }

    public List<StreamFormat> getFormats() {
        return formats;
    }

    public String getStrmPrefix() {
        return strmPrefix;
    }

    public String getStillageUrl() {
        return stillageUrl;
    }

    public Long getConvertionTaskId() {
        return convertionTaskId;
    }

    public boolean isStock() {
        return isStock;
    }

    public FileStatus getStatus() {
        return status;
    }

    public Double getDuration() {
        return duration;
    }

    public boolean isReady() {
        if (isStock()) {
            return true;
        }

        return getFormats() != null && !getFormats().isEmpty() && getStatus() == FileStatus.READY;
    }

    public boolean isShowEarlyPreviewAllowed() {
        return videoSource != null
                && videoSource.getMimeType() != null
                && videoSource.getMimeType().equalsIgnoreCase("video/mp4");
    }

    public boolean isCreateEarlyCreativeAllowed(VideoCreativeType videoCreativeType, Set<String> features) {
        return isShowEarlyPreviewAllowed()
                && videoSource.getThumbnail() != null
                && videoCreativeType != VideoCreativeType.CPM_INDOOR
                && videoCreativeType != VideoCreativeType.CPM_OUTDOOR
                && features != null
                && features.contains(CANVAS_ASYNC_VIDEO_CREATIVE_CREATION_FEATURE);
    }

    public String getEstKaltura() {
        return estKaltura;
    }

    public Movie setEstKaltura(String estKaltura) {
        this.estKaltura = estKaltura;
        return this;
    }

    public String getEstMobileVertical() {
        return estMobileVertical;
    }

    public Movie setEstMobileVertical(String estMobileVertical) {
        this.estMobileVertical = estMobileVertical;
        return this;
    }

    @Override
    public String toString() {
        return "Movie{" +
                "videoSource=" + videoSource +
                ", audioSource=" + audioSource +
                ", formats=" + formats +
                ", strmPrefix='" + strmPrefix + '\'' +
                ", stillageUrl='" + stillageUrl + '\'' +
                ", convertionTaskId=" + convertionTaskId +
                ", isStock=" + isStock +
                ", status=" + status +
                ", duration=" + duration +
                '}';
    }
}
